
package kom.itbeankit.common;


import java.util.*;
/**
 * This class defines an ItBeanCommunication event, that is used to
 * send messages from an ItBean to the framework or from an ItBean to
 * another ItBean.
 * @author Christian C. Hoffmann
 * @version 1.01 19/05/98
 */
public class ItBeanCommunicationEvent extends EventObject {
	private int id;
	private String command;
	private int commandNumber;
	public static final int COMM_FIRST = 1000;
	public static final int COMM_LAST = COMM_FIRST + 3;
	public static final int BEAN_INTERRUPTED = COMM_FIRST;
	public static final int BEAN_TERMINATED = COMM_FIRST + 1;
	public static final int ITERATION_COMPLETED = COMM_FIRST + 2;
	public static final int BEAN_STARTED = COMM_FIRST + 3;


/**
 * This constructor creates a new ItBeanCommunicationEvent.
 * @param source the object that fires the event
 * @param id int defines type of communication event
 * @param command java.lang.String additional information
 */
public ItBeanCommunicationEvent(Object source, int id, String command) {
	super(source);
	this.id = id;
	this.command = command;
}
/**
 * This constructor creates a new ItBeanCommunicationEvent.
 * @param source the object that fires the event
 * @param id defines type of communication event
 * @param command additional information
 * @param commandNumber an additional number e.g. used to transmit the number of finished iteration
 */
public ItBeanCommunicationEvent(Object source, int id, String command, int commandNumber) {
	this(source, id, command);
	this.commandNumber = commandNumber;
}
/**
 * This method returns the events command string.
 * @return java.lang.String
 */
public String getCommand() {
	return this.command;
}
/**
 * This method returns the command number which could contain the 
 * number of the finished iteration. 
 * @return the commandNumber
 */
public int getCommandNumber() {
	return this.commandNumber;
}
/**
 * This method returns the events id.
 * @return int
 */
public int getId() {
	return this.id;
}
}